\version "2.24.0"
\language "deutsch"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 1))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Ectenia mare"
  subtitle = "glasul 8"
  composer = "după N. Lungu / Gh. Cucu"
  meter = "Moderato"
  tagline=""
}

global = {
  \key f \major
  \time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  
  Prea Sfân -- tă Năs -- că -- toa -- re de Dum -- ne -- zeu, 
  mi -- lu -- ieş -- te -- ne pe noi.
  
  Prea Sfân -- tă Năs -- că -- toa -- re de Dum -- ne -- zeu, 
  mi -- lu -- ieş -- te -- ne pe noi.
    
  Ți -- e, Doam -- ne.
}

menWords = \womenWords

sopMusic = \relative c'' {
  %\cadenzaOn
  
  %a2^\f a \bar "||"
  %f,4^\mf^\<( e8[ f] g4 a\!) f4 b4\rest \bar "||"
  %f,4.^\mf^\<( e8) f4 b4\rest \bar "||"
  %a4^\mf^\<( b) a4\!^\fermata b4\rest \bar"||"
  a4^\mf^\<( b g)\! a^\fermata \bar"||"
  
  %a2^\f( g4 a bes2^\> c2) a2\! \bar "||"

  a8^\markup{\hspace #-3.2 \bold \box 1}^\p 
  a g^\< f\! g4( a)^\> f4. h8\rest\! \bar "||"
  
  a8^\markup{\hspace #-2.0 \bold \box 2} 
  a g^\< a\! b4( c)^\> a4. h8\rest\! \bar "||"
  
  c8^\markup{\hspace #-2.0 \bold \box 3} 
  a b^\< c\! d2^\> c4. h8\rest\! \bar "||" 
  
  f'8^\markup{\hspace #-2.0 \bold \box 4}
  f e^\< d\! d2^\> c4. h8\rest\! \bar "||" 
  
  d8^\markup{\hspace #-2.0 \bold \box 5}
  c b a b4^\<( c) a4.^\> h8\rest\! \bar "||"
  
  c8^\markup{\hspace #-2.0 \bold \box 6}
  c g a b4^\>( g) f4. h8\rest\! \bar "||"
  
  \partial 4
  f4^\markup{\hspace #-3.2 \bold \box 1}^\mf^\markup \bold "Prea Sfântă Născătoare"
  a8 a a^\< a \break b4^\> a8 g a^\< b c4\! \breathe
  a8^\< a b4( b8)^\> a g4 b a\! \bar "||"
  
  \partial 4
  a4^\markup{\hspace #-3.2 \bold \box 2}^\mf 
  c8 c c c f4 e8 e d d c4 
  b8 b b d c4 b a h4\rest \bar "||" 
    
  c4^\accent^\markup \bold "Ție, Doamne" c g^\<( a b^\> g) f4. h8\rest\!
  
  \bar "|."
}

altMusic = \relative c' {
  %f2 f
  %f4( e8[ f] e2) f4 b4\rest
  %c8( d4 c8) c4 b4\rest
  %f4.( e8) f4 b4\rest
  f4( e e) f4
  
  %f2( e4 f g2 a) f2
  f8 f e f e2 f4. h8\rest
  f8 f e f g4( a) f4. h8\rest
  a8 f g a b2 a4. h8\rest
  f8 a c b b2 a4. h8\rest
  b8 a g f g4( a) f4. h8\rest
  a8 a g f d4( e) f4. h8\rest
  
  f4 f8 f f f g4 f8 e f g a4
  f8 f g4( g8) f e4 g f
  
  f4 a8 a a a a4 a8 a b b a4
  g8 g g g g4 g f h4\rest
  
  a4 a g( f d e) f4. h8\rest
}

tenorMusic =  \relative c' {
  a4( b c) c 
  f,8 f g a g4( a) a4. a8\rest
  a8 a b c c2 c4. a8\rest
  c8 c c c d4( e) f4. a,8\rest
  c8 c c d d2 c4. a8\rest
  b8 a b c d4( c) c4. a8\rest
  c8 c c c c2 f,4. a8\rest
  d,4\rest d2\rest d2\rest d2\rest
  f8 f g4( g8) f g4 g f
  c'4 c8 c c c c4 c8 c d d c4
  d8 d d b c4 c c a4\rest
  f4 f e( f g2) a4. d,8\rest  
}

bassMusic =  \relative c {
  %f2 f
  %f4( e8[ f] c2) f4 r
  %f8([ d b c]) <f f,>4 r
  f4(b, c) <f f,>
  
  f8 f e f c2 f4. a8\rest
  f8 f e f b,4( c) f4. a8\rest
  f8 f f f <b b,>2 f4. a8\rest
  f8 a c b b2 f4. a8\rest
  b8 a g f b,4( c) f4. a8\rest
  f8 f e f b,4( c) f4. a8\rest
   
  %f4 f f d d g2 f4 c f f f2
  d,4\rest d2\rest d2\rest d2\rest
  f8 f g4( g8) f c4 c f
  
  f4 f8 f f f d4 c8 c b b f'4
  g8 g g g e4 e f a4\rest
  
  f4 f e( f b, c) <f f,>4. d8\rest
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \tenorMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
    \tempo 4 = 50
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
